IF EXISTS (SELECT * FROM SYS.tables WHERE NAME = 'CG_FND_VERBA_USO')
BEGIN
	GOTO FINAL
END

CREATE TABLE [dbo].[CG_FND_VERBA_USO](
	[CD_EMP] [int] NOT NULL,
	[CD_FND_VERBA_USO] [int] NOT NULL,
	[DS_FND_VERBA_USO] [VARCHAR](100),
	[CD_FORN] [int] NOT NULL,
	[TP_LANC] [int] NOT NULL,
	[STATUS] [int] NOT NULL,
	[DT_LANCTO] [datetime] NULL,
	[DT_CAD] [datetime] NULL,
	[DT_ULT_ALT] [datetime] NULL,
	[CD_USU] [int] NOT NULL,
	[CD_USU_NEGOCIADOR] [int] NOT NULL,
	[DT_INI_APURACAO] [datetime] NULL,
	[DT_FIM_APURACAO] [datetime] NULL,
	CONSTRAINT [PK_FND_VERBA_USO] PRIMARY KEY CLUSTERED 
(
	[CD_FND_VERBA_USO] ASC,
	[CD_EMP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
) ON [PRIMARY]

FINAL:

GO


IF EXISTS (SELECT * FROM SYS.default_constraints WHERE NAME = 'DF_CG_FND_VERBA_USO_CD_EMP')
BEGIN
	GOTO FINAL
END

ALTER TABLE [dbo].[CG_FND_VERBA_USO] ADD  CONSTRAINT [DF_CG_FND_VERBA_USO_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[CG_FND_VERBA_USO] ADD  CONSTRAINT [DF_CG_FND_VERBA_USO_CD_FND_VERBA_USO]  DEFAULT ((0)) FOR [CD_FND_VERBA_USO]

ALTER TABLE [dbo].[CG_FND_VERBA_USO] ADD  CONSTRAINT [DF_CG_FND_VERBA_USO_CD_FORN]  DEFAULT ((0)) FOR [CD_FORN]

ALTER TABLE [dbo].[CG_FND_VERBA_USO] ADD  CONSTRAINT [DF_CG_FND_VERBA_USO_TP_LANC]  DEFAULT ((0)) FOR [TP_LANC]

ALTER TABLE [dbo].[CG_FND_VERBA_USO] ADD  CONSTRAINT [DF_CG_FND_VERBA_USO_STATUS]  DEFAULT ((0)) FOR [STATUS]

ALTER TABLE [dbo].[CG_FND_VERBA_USO] ADD  CONSTRAINT [DF_CG_FND_VERBA_USO_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

ALTER TABLE [dbo].[CG_FND_VERBA_USO] ADD  CONSTRAINT [DF_CG_FND_VERBA_USO_CD_USU_NEGOCIADOR]  DEFAULT ((0)) FOR [CD_USU_NEGOCIADOR]

ALTER TABLE [dbo].[CG_FND_VERBA_USO]  WITH NOCHECK ADD  CONSTRAINT [FK_FND_VERBA_USO_PG_FORN] FOREIGN KEY([CD_EMP], [CD_FORN])
REFERENCES [dbo].[PG_FORN] ([CD_EMP], [CD_FORN])
ON UPDATE CASCADE

ALTER TABLE [dbo].[CG_FND_VERBA_USO] CHECK CONSTRAINT [FK_FND_VERBA_USO_PG_FORN]

FINAL: